// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 11, Aufgabe 5
// "Prioritaetenschlange"

class Element {
	int data;
	int priority;
	
	Element(int data, int priority) {
		this.data = data; this.priority = priority;
	}
	
	public String toString() {
		return "(" + data + "," + priority + ")";
	}
}


class PriorityQueue {
	static final int size = 32;
	Element[] q = new Element[size];
	int len = 0;
	
	// Insert an element into the queue according to its priority
	void put(Element x) {
		if (len == size)
			Out.println("-- queue full");
		else {
			int i = len - 1;
			while (i >= 0 && x.priority > q[i].priority) {
				q[i+1] = q[i];
				i--;
			}
			q[i+1] = x;
			len++;
		}
	}
	
	// Return the element with the highest priority from the queue
	Element get() {
		if (len > 0) {
			Element x = q[0];
			for (int i = 1; i < len; i++) q[i-1] = q[i];
			len--;
			return x;
		} else return null;
	}
	
	// Return the queue length
	int length() {
		return len;
	}
	
	// Dump the queue contents
	void dump() {
		for (int i = 0; i < len; i++) Out.print(" " + q[i]);
		Out.println();
	}
}



public class A5 {
	
	public static void main(String args[]) {
		PriorityQueue q = new PriorityQueue();
		q.put(new Element(1, 4));
		q.put(new Element(2, 9));
		q.put(new Element(3, 3));
		q.put(new Element(4, 9));
		q.put(new Element(5, 1));
		q.put(new Element(6, 2));
		q.put(new Element(7, 5));
		q.put(new Element(8, 6));
		q.dump();
		
		while (q.length() > 0) Out.println(q.get());
	}
}


/*
Here is a more efficient implementation of class
PriorityQueue that uses a so-called "heap" data structure.

class PriorityQueue {
	static final int size = 32;
	Element[] q = new Element[size]; // q[0] unused
	int nextFree = 1;
	
	void put(Element x) {
		if (nextFree < size) {
			int pos = nextFree++;
			q[pos] = x;
			while (pos > 1 && q[pos].priority > q[pos/2].priority) {
				Element y = q[pos]; q[pos] = q[pos/2]; q[pos/2] = y;
				pos = pos/2;
			}
		} else
			Out.println("-- queue overflow");
	}
	
	Element get() {
		if (nextFree > 1) {
			Element x = q[1]; q[1] = q[--nextFree];
			int pos = 1;
			for (;;) {
				int son = 2 * pos;
				if (son >= nextFree) break;
				if (son+1 < nextFree && q[son+1].priority > q[son].priority) son++;
				if (q[pos].priority >= q[son].priority) break;
				Element y = q[pos]; q[pos] = q[son]; q[son] = y;
				pos = son;
			}
			return x;
		} else return null;
	}
	
	int length() {
		return nextFree - 1;
	}
	
	void dump() {
		for (int i = 1; i < nextFree; i++) Out.print(" " + q[i]);
		Out.println();
	}
}
*/